<?php

# page generation script
$starttime = explode(' ', microtime());
$starttime = $starttime[1] + $starttime[0];

define('_VALID_INCLUDE', true);
require './functions.php';
require './structure.php';

# gather desired page from get
$action = $_GET['p'];
$cat = $_GET['c'];
$subcat = $_GET['sc'];

switch (checkpage($action, $cat, $subcat)) {

	case 'default':
		$view = './pages/' . $pages['root']['pages']['index']['url'];
		$title = $pages['root']['pages']['index']['title'];
		$description = $pages['root']['pages']['index']['desc'];
		$keywords = $pages['root']['pages']['index']['keywords'];
		$slidetype = ($pages['root']['pages']['index']['slidecss'] ? $pages['root']['pages']['index']['slidecss'] : 'slideshow');
	break;

	case 'bad':
		$view = './pages/' . $pages['root']['pages']['bad']['url'];
		$response = true;
		$title = $pages['root']['pages']['bad']['title'];
		$description = $pages['root']['pages']['bad']['desc'];
		$keywords = $pages['root']['pages']['bad']['keywords'];
		$slidetype = ($pages['root']['pages']['index']['slidecss'] ? $pages['root']['pages']['index']['slidecss'] : 'slideshow');
	break;
	
	case 'index':
		$view = './pages/' . $pages[$cat]['pages']['index']['url'];
		$title = $pages[$cat]['pages']['index']['title'];
		$description = $pages[$cat]['pages']['index']['desc'];
		$keywords = $pages[$cat]['pages']['index']['keywords'];
		$slidetype = ($pages['root']['pages']['index']['slidecss'] ? $pages['root']['pages']['index']['slidecss'] : 'slideshow');
	break;

	case 'viewpage':
		$view = './pages/' . $pages[$cat]['pages'][$action]['url'];
		$title = $pages[$cat]['pages'][$action]['title'];
		$description = $pages[$cat]['pages'][$action]['desc'];
		$keywords = $pages[$cat]['pages'][$action]['keywords'];
		$slidetype = ($pages[$cat]['pages'][$action]['slidecss'] ? $pages[$cat]['pages'][$action]['slidecss'] : 'slideshow');
	break;

	case 'rootpage':
		$view = './pages/' . $pages['root']['pages'][$action]['url'];
		$title = $pages['root']['pages'][$action]['title'];
		$description = $pages['root']['pages'][$action]['desc'];
		$keywords = $pages['root']['pages'][$action]['keywords'];
		$slidetype = ($pages['root']['pages'][$action]['slidecss'] ? $pages['root']['pages'][$action]['slidecss'] : 'slideshow');
	break;

	case 'subindex':
		$view = './pages/' . $pages[$cat]['subcats'][$subcat]['pages']['index']['url'];
		$title = $pages[$cat]['subcats'][$subcat]['pages']['index']['title'];
		$description = $pages[$cat]['subcats'][$subcat]['pages']['index']['desc'];
		$keywords = $pages[$cat]['subcats'][$subcat]['pages']['index']['keywords'];	
	break;

	case 'subviewpage':
		$view = './pages/' . $pages[$cat]['subcats'][$subcat]['pages'][$action]['url'];
		$title = $pages[$cat]['subcats'][$subcat]['pages'][$action]['title'];
		$description = $pages[$cat]['subcats'][$subcat]['pages'][$action]['desc'];
		$keywords = $pages[$cat]['subcats'][$subcat]['pages'][$action]['keywords'];	
	break;

	default:
		$view = './pages/default.php';
	break;
}

if ($response) header("HTTP/1.0 404 Not Found");

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="application/xhtml+xml;charset=utf-8"/>
	<title><?php echo $title; ?> .:: VPD &raquo; VISION photodesign, inc. ::. </title>

	<meta name="description" content="<?php echo $description; ?>"/>
	<meta name="keywords" content="<?php echo $keywords; ?>"/>
	<meta name="rating" content="General"/>
	<meta name="robots" content="index,follow"/>
	<meta name="author" content="VPD &gt; www.visionphotodesign.com"/>

	<link rel="stylesheet" href="/css2.css" type="text/css" media="all"/>
	<link rel="stylesheet" href="/slimbox.css" type="text/css" media="all"/>
	<link rel="stylesheet" href="/hs.css" type="text/css" media="all"/>
	<link rel="stylesheet" href="/<?php echo $slidetype; ?>.css" type="text/css" media="all"/>

	<script type="text/javascript">
function MM_swapImgRestore() { //v3.0
  var i,x,a=document.MM_sr; for(i=0;a&&i<a.length&&(x=a[i])&&x.oSrc;i++) x.src=x.oSrc;
}
function MM_preloadImages() { //v3.0
  var d=document; if(d.images){ if(!d.MM_p) d.MM_p=new Array();
    var i,j=d.MM_p.length,a=MM_preloadImages.arguments; for(i=0; i<a.length; i++)
    if (a[i].indexOf("#")!=0){ d.MM_p[j]=new Image; d.MM_p[j++].src=a[i];}}
}

function MM_findObj(n, d) { //v4.01
  var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))>0&&parent.frames.length) {
    d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
  if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
  for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
  if(!x && d.getElementById) x=d.getElementById(n); return x;
}

function MM_swapImage() { //v3.0
  var i,j=0,x,a=MM_swapImage.arguments; document.MM_sr=new Array; for(i=0;i<(a.length-2);i+=3)
   if ((x=MM_findObj(a[i]))!=null){document.MM_sr[j++]=x; if(!x.oSrc) x.oSrc=x.src; x.src=a[i+2];}
}
</script>

	<script type="text/javascript" src="/script/mootools-1.2-core.js"></script>
	<script type="text/javascript" src="/script/mootools-1.2-more.js"></script>
	<script type="text/javascript" src="/script/nav.js"></script>


</head>
<body class="<?php echo timeback(); ?>" onload="MM_preloadImages('images/logos/over/fb_icon.png','images/logos/over/twitter_icon.png')">

<div id="header-master"><div id="header-image">

<div id="logos">
  <table width="71" border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td width="35"><a href="http://www.facebook.com/vpdinc" target="_blank" onmouseover="MM_swapImage('fb','','images/logos/over/fb_icon.png',1)" onmouseout="MM_swapImgRestore()"><img src="images/logos/fb_icon.png" alt="become a fan" width="35" height="40" border="0" id="fb" /></a></td>
      <td width="45"><a href="http://twitter.com/visionpd" target="_blank" onmouseover="MM_swapImage('twittter','','images/logos/over/twitter_icon.png',1)" onmouseout="MM_swapImgRestore()"><img src="images/logos/twitter_icon.png" alt="follow us" width="36" height="40" border="0" id="twittter" /></a></td>
    </tr>
  </table>
 </div> 
  
</div></div><!-- /#header-master" -->

<div id="master">
	<div id="column-master" class="clearfix">
		<div id="left">
			<div id="nav">
				<?php echo createnav(); ?>			
			</div><!-- /#nav -->
		</div><!-- /#left -->

		<div id="right">
			<?php include $view; ?>
		</div><!-- /#right -->
	</div><!-- /#column-master -->

</div><!-- /#master -->

	<div id="footer" class="clearfix">
		<div class="footer-left">
			<img class="left" align="left" src="/images/vpdlogo-trans.png" alt="VISION photodesign, inc. logo"/>
			<p>Our areas of expertise include: product photography, business photography, digital photography, commercial photography, graphic design, web site design, photo editing, photo restoration, photo retouching, table top photography, industrial photography, location photography.</p>
			<p>We serve Los Angeles County, Orange County, San Diego County, Riverside County, and all other Inland Empire areas.</p>
		</div>

		<div class="footer-right">
			<p><strong>VISION photodesign, inc.</strong><br/>1950 Compton Ave unit 110<br/>Corona, CA 92881 USA</p>
			<p>talk: 951.270.1951<br/>fax: 951.270.1965</p>		
			<p>email: <a href="mailto:info@visionpd.com">info@visionpd.com</a></p>
		</div>

<?php

# output page generation time
$mtime = explode(' ', microtime());
$totaltime = $mtime[0] + $mtime[1] - $starttime;
printf('<!-- page generated in %.7f seconds. -->', $totaltime);

?>

	</div><!-- /#footer -->

	<script type="text/javascript">
		var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
		document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
	</script>

	<script type="text/javascript">
		var pageTracker = _gat._getTracker("UA-4093427-6");
		pageTracker._trackPageview();
	</script>


	<!--[if lt IE 7]>
		<script type="text/javascript" src="/script/pngfix.js"></script>
	<![endif]-->

</body>

</html>
